###############################################################################
# RecentPostsBar.pl                                                           #
###############################################################################
# RecentPostsBar.pl for YaBB2
#
# Version:        1.3
#
# Released:       January, 25, 2006
#
# Distributed by: http://www.boardmod.com
#
# =========================================================================== #
# Software by: Ferazel2001 (Devon Stewart)
#              http://devonst17.is-a-geek.com/
#
# Changelog:
#
# Version 1
# - Originally for YaBB 1.3
#
# Version 1.1
# - Ported to YaBB2
# - More customization available
# - Fixed bar size, (no longer a percentage)
#
# Version 1.2
# - Made the Color preferences customizable by Admins only
# - Added a "Quick Minimize" bar
# - Fixed a couple of bugs from 1.1
#
# Version 1.3
# - Added Language Pack support (thanks to Jans)
# - Fixed some code from version 1.2
# - Fixed a bug where clever users could still change their color settings when color change checkbox was marked off
# - Added a "Version Check"
#
###############################################################################

$recentpostsbarplver = 'RecentPosts.pl $Revision: 1.3 $';

LoadLanguage("recent_post_bar");

if ($action eq 'detailedversion') { return 1; }

sub setVars
{
&readGlobalPrefs;
&readPrefs;
$indexNum = 8;
if($prefFile[$indexNum] != 1){&resetPrefs;}

$BoardWatchDesc = "$postbar_txt{'15'}";

if($RESET eq "on"){&resetPrefs;}
else{$RESETmessage = "";}
}

sub RecentPostsBar
{
    &setVars;
$yyRecentPostsBar .=qq~
                <td valign="TOP" width="120">
		<br><table border="0" width="100%" cellspacing="0">
  <tr>
    <td width="100%">
<table border="0" width="100%" cellspacing="0" class="bordercolor" align="center" height="0">
  <tr>
    <td class="bordercolor" width="100%">
      <table width="100%" cellspacing="0" cellpadding="2">
        <tr>
          <td class="titlebg" width="558"><font size="1"><b>$postbar_txt{'1'}</b></font>&nbsp;&nbsp;&nbsp;&nbsp;<a href="$scripturl?action=recentposttoggle&action1=$INFO{'action'}&num=$INFO{'num'};start=$INFO{'start'}">&rarr;</a><br>
            <u><a href="$scripturl?action=recentpostprefs"><font size="1">$postbar_txt{'2'}</a></u>
          </td>
        </tr>
~;
    open(FILE, "$memberdir/\ Global.recentposts");
    @GprefFile = <FILE>;
    close(FILE);
open(PREFFILE, "$memberdir/$username.recentposts");
	my $RPBdisplay = $INFO{'display'} ||= <PREFFILE>;
close(PREFFILE);

	my (@memset, @categories, %data, $numfound, $curcat, %catname, %cataccess, %catboards, $openmemgr, @membergroups, %openmemgr, $curboard, @threads, @boardinfo, $i, $c, @messages, $tnum, $tsub, $tname, $temail, $tdate, $treplies, $tusername, $ticon, $tstate, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $mns, $mtime, $counter, $board, $notify);

	$numfound = 0;

	unless ($mloaded == 1) { require "$boardsdir/forum.master"; }
	foreach $catid (@categoryorder) {
		$boardlist = $cat{$catid};

		(@bdlist) = split(/\,/, $boardlist);
		($catname, $catperms) = split(/\|/, $catinfo{"$catid"});
		$cataccess = &CatAccess($catperms);
		if (!$cataccess) { next; }

		foreach $curboard (@bdlist) {
			($boardname{$curboard}, $boardperms, $boardview) = split(/\|/, $board{"$curboard"});

			my $access = &AccessCheck($curboard, '', $boardperms);
			if (!$iamadmin && $access ne "granted") { next; }

			$catname{$curboard} = $catname;

			fopen(REC_BDTXT, "$boardsdir/$curboard.txt");
			for ($i = 0; $i < $RPBdisplay && ($buffer = <REC_BDTXT>); $i++) {
				($tnum, $tsub, $tname, $temail, $tdate, $treplies, $tusername, $ticon, $tstate) = split(/\|/, $buffer);
				unless ($tstate =~ /h/) {
					$mtime = $tdate;
					$data[$numfound] = "$mtime|$curboard|$tnum|$treplies|$tusername|$tname|$tstate";
					$numfound++;
				}
			}
			fclose(REC_BDTXT);
		}
	}

	@data     = reverse sort @data;
	$numfound = 0;

	for ($i = 0; $i < @data; $i++) {
		($mtime, $curboard, $tnum, $treplies, $tusername, $tname, $tstate) = split(/\|/, $data[$i]);
		unless ($tstate =~ /h/) {
			fopen(REC_THRETXT, "$datadir/$tnum.txt") || next;
			while (<REC_THRETXT>) { $message = $_; }

			# get only the last post for this thread.
			fclose(REC_THRETXT);
			chomp $message;

			if ($message) {
				($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $message, $mns) = split(/\|/, $message);
				$messages[$numfound] = "$curboard|$tnum|$treplies|$tusername|$tname|$msub|$mname|$memail|$mdate|$musername|$micon|$mattach|$mip|$message|$mns|$tstate";
				$numfound++;
			}
			if ($numfound == $RPBdisplay) { last; }
		}
	}

	if ($numfound > 0) {
		$counter = 1;
		&LoadCensorList;
	} else {
		$yyRecentPostsBar .= qq~<b>$postbar_txt{'3'}</b>~;
	}
	for ($i = 0; $i < $numfound; $i++) {
		($board, $tnum, $c, $tusername, $tname, $msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip, $message, $mns, $tstate) = split(/\|/, $messages[$i]);
		$RPBdisplayname = $mname;

		if ($tusername ne 'Guest' && -e ("$memberdir/$tusername.vars")) { &LoadUser($tusername); }
		if (${$uid.$tusername}{'regtime'}) {
			$registrationdate = ${$uid.$tusername}{'regtime'};
		} else {
			$registrationdate = int(time);
		}
		if (${$uid.$tusername}{'regdate'} && $mtime > $registrationdate) {
			$tname = qq~<a href="$scripturl?action=viewprofile;username=$tusername">${$uid.$tusername}{'realname'}</a>~;
		} elsif ($tusername !~ m~Guest~ && $mtime < $registrationdate) {
			$tname = qq~$tusername - $maintxt{'470a'}~;
		} else {
			$tname = "$tusername";
		}
		if ($musername ne 'Guest' && -e ("$memberdir/$musername.vars")) { &LoadUser($musername); }
		if (${$uid.$musername}{'regtime'}) {
			$registrationdate = ${$uid.$musername}{'regtime'};
		} else {
			$registrationdate = int(time);
		}
		if (${$uid.$musername}{'regdate'} && $mdate > $registrationdate) {
			$mname = qq~<a href="$scripturl?action=viewprofile;username=$musername">${$uid.$musername}{'realname'}</a>~;
		} elsif ($musername !~ m~Guest~ && $mdate < $registrationdate) {
			$mname = qq~$musername - $maintxt{'470a'}~;
		} else {
			$mname = "$musername";
		}

		$message = &Censor($message);
		$msub    = &Censor($msub);

		&wrap;
		if ($enable_ubbc) {
			$ns = $mns;
			if (!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; }
			&DoUBBC;
		}
		&wrap2;
		&ToChars($msub);
		&ToChars($message);
		&ToChars($boardname{$board});
		$msub =~ s/\A\[m\]/$maintxt{'758'}/;

		$mdate = &timeformat($mdate);

	$boardWatchEnable = 0;
	# eq $RPBboardwatch
	@BoardWatch = split(/,/, $RPBboardwatch);
	for($BWCount = 0; $BWCount < @BoardWatch; $BWCount++)
	{
	 if($boardname{$board} eq $BoardWatch[$BWCount])
	 {
	  $boardWatchEnable = 1;
	 }
	}

		$yyRecentPostsBar .= qq~
          <tr>~;
if($boardWatchEnable)
{$yyRecentPostsBar .= qq~<TD style="width:100%; background-color:#$RPBboardwatchColor"~;}
else
{$yyRecentPostsBar .= qq~<TD style="width:100%; background-color:#$RPBbgcolor"~;}
            if($RPBcolorchange eq "on")
            {
            $yyRecentPostsBar .=qq~ onMouseover="this.style.backgroundColor='#$RPBhlcolor';"~;

if($boardWatchEnable)
{$yyRecentPostsBar .= qq~onMouseout="this.style.backgroundColor='#$RPBboardwatchColor';"~;}
else
{$yyRecentPostsBar .= qq~onMouseout="this.style.backgroundColor='#$RPBbgcolor';"~;}
            }
           $yyRecentPostsBar .= qq~><a href="$scripturl?board=$board;action=display;num=$tnum;start=$c#$c"><font style="color:#$RPBtextcolor" size="1">$msub</a><br>
          by $mname<br>
          $mdate</font>
          </td>
        </tr>
~;
if($counter != $RPBdisplay)
{
$yyRecentPostsBar .= qq~
        <tr>
        	<td class="windowbg2">
        		<hr>
        	</td>
        </tr>
~;
}
		++$counter;
	}

	$yyRecentPostsBar .= qq~
</table>
    		</td>
  	</tr>
</table>
       </td>
    </tr>
</table>
    </td>
~;
if($RPBminimized == 1)
{

$yyRecentPostsBar = qq~<td valign="TOP">
<br>
<table class="bordercolor" cellspacing="1" cellpadding="2">
<td class="windowbg2">
<a href="$scripturl?action=recentposttoggle&action1=$INFO{'action'}&num=$INFO{'num'};start=$INFO{'start'}">&larr;</a><br />
<a href="$scripturl?action=recentpostprefs">$postbar_txt{'16'}</a>
</td>
</table>
</td>~;
}
}

sub toggle
{
&setVars;

if($RPBminimized == 0)
{
$RPBminimized = 1;
}
else
{
$RPBminimized = 0;
}

&writeRPBPrefs;
$yySetLocation = qq~$scripturl?action=$INFO{'action1'};num=$INFO{'num'};start=$INFO{'start'}~;
&redirectexit;
}

sub prefs
{
    &setVars;
    if (!(-e "$memberdir/$username.recentposts")) {
        &resetPrefs;
    }
    if($RPBcolorchange eq "on")
    {
	$RPBcolorchangecheck = "checked";
    }
    else
    {
	$RPBcolorchangecheck = "";
    }

    if(!($RPBGcolorchange eq "on"))
    {
	$RPBGcolorchange = "off";
    }

$yytitle = "$postbar_txt{'13'}";
$yymain .=qq~
<br>
<h4><center><font color="red"><font size="2">$RESETmessage</font></color></h4>
<table border="0" width="90%" cellspacing="0" class="bordercolor" align="center" height="0">
    <td class="bordercolor" width="100%">
      <table width="100%" cellspacing="0" cellpadding="2">
        <tr class="windowbg2">
          	<td class="titlebg" width="558" align="center"><font size="2">$postbar_txt{'13'}</font></td>
        </tr>
				<tr class="windowbg2">
					<td><center><a href="$scripturl?action=recentposthelp">$postbar_txt{'14'}</a></center></td>
				</tr>
      </table>
    </td>
  </tr>
</table>
<center>
<form action="$scripturl?action=recentpostprefs2" method="post">
<table width="90%" class="bordercolor" cellpadding="2" cellspacing="1">
	<tr class="windowbg2">
		<td width="45%" align="left">$postbar_txt{'4'}</td>
		<td align="left"><input type=input name=display size=5 value="$RPBdisplay"></td>
		<td align="left">[$RPBGdisplay]</td>
	</tr>
	<tr class="windowbg2">
		<td width="45%" align="left">$postbar_txt{'5'}</td>
		<td align="left"><input type=checkbox name=colorchange $RPBcolorchangecheck></td>
		<td align="left">[$RPBGcolorchange]</td>
	</tr>
~;
if($RPBGusersCanModifyHexColors eq "on")
{
$yymain .= qq~
	<tr class="windowbg2">
		<td align="left">$postbar_txt{'6'}</td>
		<td align="left"><input type=input name=bgcolor size=6 value="$RPBbgcolor"></td>
		<td align="left">[$RPBGbgcolor]</td>
	</tr>
	<tr class="windowbg2">
		<td align="left">$postbar_txt{'7'}</td>
		<td align="left"><input type=input name=hlcolor size=6 value="$RPBhlcolor"></td>
		<td align="left">[$RPBGhlcolor]</td>
	</tr>
	<tr class="windowbg2">
		<td align="left">$postbar_txt{'8'}</td>
		<td align="left"><input type=input name=textcolor size=6 value="$RPBtextcolor"></td>
		<td align="left">[$RPBGtextcolor]</td>
	</tr>
~;
}
$yymain .= qq~
	<tr class="windowbg2">
		<td width="45%" align="left">$postbar_txt{'9'}</td>
		<td align="left"><input type=input name=boardwatch size=25 value="$RPBboardwatch"></td>
		<td align="left">[$BoardWatchDesc]</td>
	</tr>
~;
if($RPBGusersCanModifyHexColors eq "on")
{
$yymain .= qq~
	<tr class="windowbg2">
		<td align="left">$postbar_txt{'10'}</td>
		<td align="left"><input type=input name=boardwatchColor size=6 value="$RPBboardwatchColor"></td>
		<td align="left">[$RPBGboardwatchColor]</td>
	</tr>
~;
}
$yymain .= qq~
</table>
<input type=hidden name=minimized value="$RPBminimized"><br><br><center><input type=submit></center>
</form>
</center>
~;
if(!(-e "$memberdir/ Global.recentposts"))
{
$yymain = "<center><font size=+1 color=red>$postbar_txt{'11'}</font></center><br>";
$yymain .= "<center>$postbar_txt{'12'}</center>";
}

&template;
exit;
}

sub prefs2 {
    &setVars;
    &preventHacks;

    $RPBdisplay = $FORM{'display'};
    $RPBcolorchange = $FORM{'colorchange'};
    $RPBbgcolor = $FORM{'bgcolor'} || $RPBGbgcolor;
    $RPBhlcolor = $FORM{'hlcolor'} || $RPBGhlcolor;
    $RPBtextcolor = $FORM{'textcolor'} || $RPBGtextcolor;
    $RPBboardwatch = $FORM{'boardwatch'};
    $RPBboardwatchColor = $FORM{'boardwatchColor'} || $RPBGboardwatchcolor;
    $RPBminimized = $FORM{'minimized'};


    $RPBboardwatch =~ s~, ~,~g;

    if($RPBdisplay < 1)
    {
    $RPBdisplay = 1;
    }
    if($RPBdisplay > 40)
    {
    $RPBdisplay = 40;
    }
    
&writeRPBPrefs;

	$yySetLocation = qq~$scripturl?action=recentpostprefs~;
	&redirectexit;
}

sub resetPrefs
{
if(-e "$memberdir/ Global.recentposts")
{
    open(FILE, ">$memberdir/$username.recentposts");
print FILE qq~$RPBGdisplay
$RPBGcolorchange
$RPBGbgcolor
$RPBGhlcolor
$RPBGtextcolor
$RPBGboardwatch
$RPBGboardwatchColor
$RPBminimized
1
~;
    close(FILE);
$RPBdisplay = $RPBGdisplay;
$RPBcolorchange = $RPBGcolorchange;
$RPBbgcolor = $RPBGbgcolor;
$RPBhlcolor = $RPBGhlcolor;
$RPBtextcolor = $RPBGtextcolor;
$RPBboardwatch = $RPBGboardwatch;
$RPBboardwatchColor = $RPBGboardwatchColor;
}
}

sub readPrefs
{
    open(FILE, "$memberdir/$username.recentposts");
    @prefFile = <FILE>;
    close(FILE);
    $RPBdisplay = $prefFile[0];
    chomp $RPBdisplay;
    $RPBcolorchange = $prefFile[1];
    chomp $RPBcolorchange;
    $RPBbgcolor = $prefFile[2];
    chomp $RPBbgcolor;
    $RPBhlcolor = $prefFile[3];
    chomp $RPBhlcolor;
    $RPBtextcolor = $prefFile[4];
    chomp $RPBtextcolor;
    $RPBboardwatch = $prefFile[5];
    chomp $RPBboardwatch;
    $RPBboardwatchColor = $prefFile[6];
    chomp $RPBboardwatchColor;
    $RPBminimized = $prefFile[7];
    chomp $RPBminimized;
}

sub writeRPBPrefs
{
if(-e "$memberdir/ Global.recentposts")
{
open(FILE, ">$memberdir/$username.recentposts");
print FILE qq~$RPBdisplay
$RPBcolorchange
$RPBbgcolor
$RPBhlcolor
$RPBtextcolor
$RPBboardwatch
$RPBboardwatchColor
$RPBminimized
1
~;
    close(FILE);
}
}

sub help
{
&setVars;
$yymain = "<h3>$help_txt{'0'}</h3>";
$yymain .= "<a href=\"$scripturl?action=recentpostprefs\">$help_txt{'1'}</a><br><br>";
$yymain .= qq~<table class="bordercolor" cellspacing="1" cellpadding="2">
	<tr>
		<td class="titlebg">$help_txt{'choice'}</td>
		<td class="titlebg">$help_txt{'value'}</td>
		<td class="titlebg">$help_txt{'descr'}</td>
	</tr>
	<tr>
		<td class="windowbg2">$help_txt{'2'}</td>
		<td class="windowbg2">[$RPBGdisplay]</td>
		<td class="windowbg2">$help_txt{'3'}</td>
	</tr>
	<tr>
		<td class="windowbg2">$help_txt{'4'}</td>
		<td class="windowbg2">[$RPBGcolorchange]</td>
		<td class="windowbg2">$help_txt{'5'}</td>
	</tr>
	<tr>
		<td class="windowbg2">$help_txt{'6'}</td>
		<td class="windowbg2">[$RPBGbgcolor]</td>
		<td class="windowbg2">$help_txt{'7'}</td>
	</tr>
	<tr>
		<td class="windowbg2">$help_txt{'8'}</td>
		<td class="windowbg2">[$RPBGhlcolor]</td>
		<td class="windowbg2">$help_txt{'9'}</td>
	</tr>
	<tr>
		<td class="windowbg2">$help_txt{'10'}</td>
		<td class="windowbg2">[$RPBGtextcolor]</td>
		<td class="windowbg2">$help_txt{'11'}</td>
	</tr>
	<tr>
		<td class="windowbg2">$help_txt{'12'}</td>
		<td class="windowbg2">[$BoardWatchDesc]</td>
		<td class="windowbg2">$help_txt{'13'}</td>
	</tr>
	<tr>
		<td class="windowbg2">$help_txt{'14'}</td>
		<td class="windowbg2">[$RPBGboardwatchColor]</td>
		<td class="windowbg2">$help_txt{'14a'}</td>
	</tr>
	<tr>
		<td class="windowbg2">&larr;&nbsp;&nbsp;&rarr;<br /> $help_txt{'15'}</td>
		<td class="windowbg2">[$help_txt{'16'}]</td>
		<td class="windowbg2">$help_txt{'17'}</td>
	</tr>
</table>
~;
&template;
exit;
}

sub readGlobalPrefs
{
    open(FILE, "$memberdir/\ Global.recentposts");
    @GprefFile = <FILE>;
    close(FILE);

    $RPBGdisplay = $GprefFile[0];
    chomp $RPBGdisplay;
    $RPBGcolorchange = $GprefFile[1];
    chomp $RPBGcolorchange;
    $RPBGbgcolor = $GprefFile[2];
    chomp $RPBGbgcolor;
    $RPBGhlcolor = $GprefFile[3];
    chomp $RPBGhlcolor;
    $RPBGtextcolor = $GprefFile[4];
    chomp $RPBGtextcolor;
    $RPBGboardwatch = $GprefFile[5];
    chomp $RPBGboardwatch;
    $RPBGboardwatchColor = $GprefFile[6];
    chomp $RPBGboardwatchColor;
    $RPBGindexNum = $GprefFile[7];
    chomp $RPBGindexNum;
    $RPBGusersCanModifyHexColors = $GprefFile[8];
    chomp $RPBGusersCanModifyHexColors;
    $RESET = $GprefFile[9];
    chomp $RESET;
    $RESETmessage = $GprefFile[10];
    chomp $RESETmessage;
}
sub preventHacks
{
&readGlobalPrefs;

  if($RESET == 1)
  {
    $FORM{'bgcolor'} = $RPBGbgcolor;
    $FORM{'hlcolor'} = $RPBGhlcolor;
    $FORM{'textcolor'} = $RPBGtextcolor;
    $FORM{'boardwatchColor'} = $RPBGboardwatchColor;
  }
}
1;
